<?php
setlocale(LC_CTYPE, 'es_MX');
include "core/controller/Core.php";
include "core/controller/Database.php";
include "core/controller/Executor.php";
include "core/controller/Model.php";
include "core/app/model/UserData.php";
include "core/app/model/SellData.php";
include "core/app/model/OperationData.php";
include "core/app/model/ProductData.php";
include "core/app/model/StockData.php";
include "core/app/model/ConfigurationData.php";
include "core/app/model/PersonData.php";
include 'connection/conexion.php';
include "fpdf/fpdf.php";
session_start();
if (isset($_SESSION["user_id"])) {
    Core::$user = UserData::getById($_SESSION["user_id"]);
}


$symbol = ConfigurationData::getByPreffix("currency")->val;
if ($symbol == "€") {
    $symbol = chr(128);
} else if ($symbol == "₡") {
//echo intval("€");
    $symbol = '₡';
}

$name = ConfigurationData::getByPreffix("company_name")->val;
$title = ConfigurationData::getByPreffix("ticket_title")->val;
$direction = ConfigurationData::getByPreffix("direction")->val;
$calle = ConfigurationData::getByPreffix("calle")->val;
$rfc = ConfigurationData::getByPreffix("rfc")->val;
$telefono = ConfigurationData::getByPreffix("telefono")->val;
$iva_val = ConfigurationData::getByPreffix("imp-val")->val;
$ticket_image = ConfigurationData::getByPreffix("ticket_image")->val;


$cliente = $_GET['client_id'];

/*
$idabono = $_GET['id'];
$fecha = $_GET['fecha'];
$stock_id = $_GET['stock_id'];


/*
$suc_name = "SELECT * from stock where id = $stock_id";
$resultado = $mysqli->query($suc_name);
$row = mysqli_fetch_assoc($resultado);
$nombre_sucursal = $row['name']; 
*/


$sql_cliente = "SELECT * from person where id = $cliente";
$res_cliente = $mysqli->query($sql_cliente);
$row = mysqli_fetch_assoc($res_cliente);
$idcliente =  $row['id'];
$nombre_cliente = $row['name']."".$row['lastname']; 
$direccion_cliente = $row['address1']; 
$telefono_cliente = $row['phone1'];
$rfc_cliente =  $row['no'];


$total_credito = "SELECT SUM(val) AS total_creditos from payment where person_id = $cliente and payment_type_id = 1 and liquidado = 0 and cancelado = 0 ";
$res_credito = $mysqli->query($total_credito);
$row1 = mysqli_fetch_assoc($res_credito);
$monto_total = $row1['total_creditos']; 

$total_abonos= "SELECT SUM(val) AS total_abonos from payment where person_id = $cliente and payment_type_id = 2 and liquidado = 0 and cancelado = 0 ";
$res_abonos = $mysqli->query($total_abonos);
$row2 = mysqli_fetch_assoc($res_abonos);
$monto_abonos = $row2['total_abonos']; 
$abonos = $monto_abonos * -1;
$total_porcobrar = $monto_total - $abonos;

$pdf = new FPDF($orientation = 'P', $unit = 'mm');

$pdf->AddPage();
$pdf->SetFont('Arial', '', 6);    //Letra Arial, negrita (Bold), tam. 20
//$pdf->AddFont('DejaVu','','DejaVuSansCondensed.ttf',true);
//$pdf->SetFont('DejaVu','',8);
//$pdf->setXY(5,0);
$plusforimage = 0;
if ($ticket_image != "") {
    $src = "storage/configuration/" . $ticket_image;
    if (file_exists($src)) {
        $pdf->Image($src, 5, 4, 85);
        $plusforimage = 25;
    }
}

date_default_timezone_set('America/Monterrey');
$pdf->SetFont('Arial', 'B', 9);

$ancho = 190;
$pdf->SetY(12); //Mencionamos que el curso en la posición Y empezará a los 12 puntos para escribir el Usuario:

$pdf->SetY(15);
$pdf->Cell($ancho, 13,'Fecha Impresion : '.date('d/m/Y'), 0, 0, 'R');
$pdf->SetY(18);
$pdf->Cell($ancho, 16,'Hora Impresion : '.date('H:i:s'), 0, 0, 'R');     



$yy = 15; //Variable auxiliar para desplazarse 40 puntos del borde superior hacia abajo en la coordenada de las Y para evitar que el título este al nivel de la cabecera.
$y = $pdf->GetY(); 
$x = 12;
$pdf->SetFont('helvetica', 'B', 20); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(0, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(220, 20, "Antiguedad De Saldos", 0, 4, 'C');
$pdf->SetFont('helvetica', 'B', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(95, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página

$pdf->SetFont('helvetica', 'B', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,50,"Informacion General Del Cliente  _____________________________________________________________________");

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,65, "Nombre Cliente : ".$nombre_cliente);

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,75, "RFC : ".$rfc_cliente);

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(140, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,70, "Telefono : ".$telefono_cliente);

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,85, "ID Cliente : ".$idcliente);

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,95, "Ciudad / Estado : ".$direccion_cliente);


$pdf->SetFont('helvetica', 'B', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(135, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,110, "Credito Por Liquidar : $ ".$total_porcobrar);



$pdf->SetFont('helvetica', 'B', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,120,"Listado General de Abonos A Compras  ______________________________________________________________");


$sql = "SELECT * from payment where person_id = $cliente and liquidado = 0 and cancelado = 0  order by sell_id,created_at";
 $resultado = $mysqli->query($sql);


 $pdf->ln(70);
 $pdf->SetFont('courier', 'U', 15); //Asignar la fuente, el estilo de la fuente (subrayado) y el tamaño de la fuente
 $y = $pdf->GetY(); 
 $pdf->SetXY(40, $y); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
 $pdf->SetFont('arial', '', 8); //Asignar la fuente, el estilo de la fuente (subrayado) y el tamaño de la fuente
 $y = $pdf->GetY() + 1;
 $pdf->SetXY(10, $y);
 $pdf->MultiCell(20, 4, utf8_decode("ID Compra"), 1, 'C'); //Utilizamos el utf8_decode para evitar código basura o ilegible
 $pdf->SetXY(30, $y);
 $pdf->MultiCell(25, 4, utf8_decode("$ Total"), 1, 'C');
 $pdf->SetXY(55, $y);
 $pdf->MultiCell(50, 4, utf8_decode("Fecha Compra Credito"), 1, 'C');  
 $pdf->SetXY(105, $y);
 $pdf->MultiCell(30, 4, utf8_decode("$ Total Abono"), 1, 'C');
 $pdf->SetXY(135, $y);
 $pdf->MultiCell(20, 4, utf8_decode("Fecha Abono"), 1, 'C');  
 $pdf->SetXY(155, $y);
 $pdf->MultiCell(27, 4, utf8_decode("Codigo Abono"), 1, 'C');  
 $pdf->SetFont('arial', '', 8); //Asignar la fuente, el estilo de la fuente (subrayado) y el tamaño de la fuente
 $pdf->SetXY(182, $y);
 $pdf->MultiCell(19, 4, utf8_decode("Status"), 1, 'C');  
 $pdf->SetFont('arial', '', 8); //Asignar la fuente, el estilo de la fuente (subrayado) y el tamaño de la fuente
 $pdf->ln(2);
 
 $total_entregado=0;

$total =0;
$abonado =0;
$diferencia =0;

 while($row = $resultado->fetch_assoc()){

  if($row['payment_type_id'] == '1'){
  $abono = "-";
  }else if($row['payment_type_id'] == '2'){
  $abono = $row['val'] * -1;
  }

  if($row['payment_type_id'] == '2'){
    $total_compra = "-";
    }else if($row['payment_type_id'] == '1'){
    $total_compra = $row['val'] ;
    }

    if($row['payment_type_id'] == '2'){
    $fechac = "-";
    }else if($row['payment_type_id'] == '1'){
    $fechac = $row['created_at'] ;
    }
    
    if($row['payment_type_id'] == '2'){
    $fechaa = $row['created_at'] ;
    }else if($row['payment_type_id'] == '1'){
    $fechaa = "-";
    }
    
    if($row['liquidado'] == '1' && $row['payment_type_id'] == '1' ){
        $pagada = "Liquidado";
    }else if ($row['liquidado'] == '0' && $row['payment_type_id'] == '1' ) {
        $pagada = "Pendiente";
    } else{

        $pagada = "Abono";
    }
          



$pdf->cell(20, 7,$row['sell_id'],1,0,'C');
$pdf->cell(25, 7,"$ ".$total_compra,1,0,'C');
$pdf->cell(50, 7,$fechac,1,0,'C');
$pdf->cell(30, 7,"$ ".$abono,1,0,'C');
$pdf->cell(20, 7,$fechaa,1,0,'C');
$pdf->cell(27, 7,$row['id_pago'],1,'C');
$pdf->Multicell(19, 7,$pagada,1,'C');
$pdf->ln(2);


$total += $total_compra;
$abonado +=$abono;
$diferencia = $total - $abonado; 

}


$pdf->ln(2);
$pdf->SetFont('helvetica', 'B', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetX(20);
$pdf->cell(10, 7,"Total Comprado $ ".number_format($total,2,".","."));


$pdf->SetFont('helvetica', 'B', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetX(90);
$pdf->cell(15, 7,"Total Abonado $ ".number_format($abonado,2,".","."));

$pdf->SetFont('helvetica', 'B', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetX(150);
$pdf->cell(15, 7,"Por Pagar $ ".number_format($diferencia,2,".","."));

$pdf->ln(12);




$pdf->output();


        
 
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    



 








































