<?php
setlocale(LC_CTYPE, 'es_MX');
include "core/controller/Core.php";
include "core/controller/Database.php";
include "core/controller/Executor.php";
include "core/controller/Model.php";
include "core/app/model/UserData.php";
include "core/app/model/SellData.php";
include "core/app/model/OperationData.php";
include "core/app/model/ProductData.php";
include "core/app/model/StockData.php";
include "core/app/model/ConfigurationData.php";
include "core/app/model/PersonData.php";
include "fpdf/fpdf.php";

session_start();
if (isset($_SESSION["user_id"])) {
    Core::$user = UserData::getById($_SESSION["user_id"]);
}
$symbol = ConfigurationData::getByPreffix("currency")->val;
if ($symbol == "€") {
    $symbol = chr(128);
} else if ($symbol == "₡") {
//echo intval("€");
    $symbol = '₡';
}

$title = ConfigurationData::getByPreffix("ticket_title")->val;
$cp = ConfigurationData::getByPreffix("codigo_postal")->val;
$company_name = ConfigurationData::getByPreffix("company_name")->val;
$colonia = ConfigurationData::getByPreffix("colonia")->val;
$direction = ConfigurationData::getByPreffix("direction")->val;
$calle = ConfigurationData::getByPreffix("calle")->val;
$rfc = ConfigurationData::getByPreffix("rfc")->val;
$calle = ConfigurationData::getByPreffix("calle")->val;
$telefono = ConfigurationData::getByPreffix("telefono")->val;
$whatsapp = ConfigurationData::getByPreffix("whatsapp")->val;
$iva_val = ConfigurationData::getByPreffix("imp-val")->val;
$ticket_image = ConfigurationData::getByPreffix("ticket_image")->val;
$sell = SellData::getById($_GET["id"]);
$stock = StockData::getById($sell->stock_to_id);
$operations = OperationData::getAllProductsBySellId($_GET["id"]);
$user = $sell->getUser();
$pdf = new FPDF($orientation = 'P', $unit = 'mm', array(98, 400));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 6);    //Letra Arial, negrita (Bold), tam. 20
//$pdf->AddFont('DejaVu','','DejaVuSansCondensed.ttf',true);
//$pdf->SetFont('DejaVu','',8);
//$pdf->setXY(5,0);
$plusforimage = 0;
if ($ticket_image != "") {
    $src = "storage/configuration/" . $ticket_image;
    if (file_exists($src)) {
        $pdf->Image($src, 20, 2, 40);
        $plusforimage = 48;
    }
}


$textypos = 8 + $plusforimage;
//$pdf->ln(2);
//$pdf->setY(3);
//$pdf->setX(11);
//$pdf->Cell(3, $textypos, strtoupper($company_name));
$pdf->setY(10);
$pdf->SetFont('courier', 'B', 12);
$pdf->setY(17);
$pdf->setX(17);
$pdf->SetFont('courier', 'B', 11);
$pdf->Cell(5, $textypos, strtoupper($stock->name));
$pdf->setY(21);
$pdf->setX(14);
$pdf->SetFont('courier', '', 10);
$pdf->Cell(5, $textypos, strtoupper($stock->colonia));
$pdf->setY(25);
$pdf->setX(20);
$pdf->SetFont('courier', '', 11);
$pdf->Cell(5, $textypos, strtoupper($calle));
$pdf->setY(29);
$pdf->setX(15);
$pdf->Cell(5, $textypos, strtoupper($stock->ciudad));
$pdf->setY(33);
$pdf->setX(9);
$pdf->Cell(5, $textypos, "Telefono:  " . strtoupper($stock->field1));
$pdf->setY(37);
$pdf->setX(9);
$pdf->Cell(5, $textypos, "WhatsApp:  " . strtoupper($stock->field2));
$pdf->setY(24);
$pdf->setX(2);

$pdf->SetFont('courier', 'B', 11);
$pdf->setY(42);
$pdf->setX(2);
$pdf->Cell(5, $textypos, "================================");

$pagado = 0;
// se saca el estado del pago // pagado pendiente.
if($sell->p_id == 1 ){
    $pagado = "Pagada";
}else if ($sell->p_id ==2 ){
    $pagado = "Pendiente";
}else if ($sell->p_id ==4 ){
    $pagado = "Credito";
}

$entregado = 0;
// se saca el estado de entrega // entregado - pendiente.
if($sell->d_id == 1 ){
    $entregado = "Entregada";
}else if ($sell->d_id ==2 ){
    $entregado = "Pendiente";
}

$f_pago = 0;
// se saca el estado de entrega // entregado - pendiente.
if($sell->f_id == 1 ){
    $f_pago = "Efectivo";
}else if ($sell->f_id ==2 ){
    $f_pago = "Transferencia";
}else if ($sell->f_id ==3 ){
    $f_pago = "Tarjeta De Credito";
}else if ($sell->f_id ==4 ){
    $f_pago = "Tarjeta De Debito";
}else if ($sell->f_id ==5 ){
    $f_pago = "Cobro Con Anticipo";
}else if ($sell->f_id ==6 ){
    $f_pago = "Deposito Bancario";
}else if ($sell->f_id ==7 ){
    $f_pago = "Pago Con Cheque";
}else if ($sell->f_id ==8 ){
    $f_pago = "Por Definir";
}


//$pdf->SetFont('DejaVu','',5);    //Letra Arial, negrita (Bold), tam. 20
$pdf->SetFont('courier', 'B', 5);    //Letra Arial, negrita (Bold), tam. 20
$textypos += 9;
$pdf->setX(2);

$textypos += 1;
$pdf->setX(16);
$pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, " # Remision - " . $sell->id);
$pdf->ln(4);
$pdf->setX(8);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(20, $textypos, "Fecha : " . $sell->fecha_remision);
$pdf->ln(4);

$pdf->setX(21);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, "Pago  : " . $pagado);
$pdf->ln(4);

$pdf->setX(17);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, "Entrega : " . $entregado);
$pdf->ln(4);

$pdf->setX(6);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, "Forma Pago : " . $f_pago);


if($sell->remision_recuperada == 1 ){

    $pdf->ln(4);
$pdf->setX(6);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(20, $textypos, "Fecha Pago : " . $sell->fecha_pago);

}

if ($sell->person_id != null) {
    $textypos += 10;
    $pdf->setX(2);
    $pdf->SetFont('courier', 'B', 11);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, '=== Informacion Del Cliente ===');

    $client = PersonData::getById($sell->person_id);

    $textypos += 8;
    $pdf->setX(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, "RFC : " . strtoupper($client->no));

    $textypos += 8;
    $pdf->setX(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, "Telefono: " . strtoupper($client->phone1));

    $pdf->ln(50);
    $pdf->setX(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,4, "Cliente: " .$client->name . ' ' . $client->lastname);

    $pdf->ln(1);
    $pdf->setx(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,4, "Direccion: " .utf8_decode($client->address1),'C');
   
}

$textypos += -80;
$pdf->setX(2);
$pdf->SetFont('courier', 'b', 12);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(5, $textypos, '===== Listado Productos =====');
$textypos += 10;
$pdf->setX(4);
$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(5, $textypos, 'CANT   DESCRIPCION   PRECIO  TOTAL');

$total = 0;
$acumulador =0;
$off = $textypos + -24;
$pdf->ln(14);
foreach ($operations as $op) {
    $product = $op->getProduct();
 
    $pdf->setX(4);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,3,$op->q);

    $pdf->setX(4);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,4,utf8_encode($op->descripcion));

    $pdf->setX(15);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,6,"$symbol " . number_format($op->price_out, 2, ".", ",")."    $symbol " . number_format($op->q * $op->price_out, 2, ".", ","));
   
    $total += $op->q * $product->price_out;
    $acumulador += $op->q;
   


    /*
    $pdf->setX(5);
    $pdf->ln(5);
    $pdf->setX(30);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(1, $off, "$symbol " . number_format($op->price_out, 2, ".", ","), 0, 0, "R");
    $pdf->setX(60);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(1, $off, "$symbol " . number_format($op->q * $op->price_out, 2, ".", ","), 0, 0, "R");

//    ".."  ".number_format($op->q*$product->price_out,2,".",","));
      $total += $op->q * $product->price_out;
      $acumulador += $op->q;
*/

} 

$textypos += 6;
//////////////////////////////////////////////
 if (Core::$plus_iva == 1) {

    $textypos += -16;
    $pdf->setX(2);
    $pdf->SetFont('courier', 'B', 11);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, '======== Datos De Venta ========');

    $total = $sell->total;
    $iva_calc = ( ($total) / (1 + ($iva_val / 100) )) * ($iva_val / 100);
    $pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
     
    $pdf->setX(5);
    $pdf->Cell(5, $off + 23, "SubTotal :  ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 23, "$symbol " . number_format($sell->sub_total , 2, ".", ","), 0, 0, "R");
    
    $pdf->setX(5);
    $pdf->Cell(5, $off + 34, "Impuesto :  ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 34, "$symbol " . number_format($sell->iva, 2, ".", ","), 0, 0, "R");


    $pdf->setX(5);
    $pdf->Cell(5, $off + 46, "Total :  ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 46, "$symbol " . number_format($total, 2, ".", ","), 0, 0, "R");
    

    $pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->setX(5);
    $pdf->Cell(5, $off + 57, "Anticipo : ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 57, "$symbol " . number_format($sell->reg_anticipo, 2, ".", ","), 0, 0, "R");

    /*
    $pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->setX(5);
    $pdf->Cell(5, $off + 63, "Efectivo : ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 63, "$symbol " . number_format($sell->cash, 2, ".", ","), 0, 0, "R");
*/

/*
    $cambio = $sell->cash - ($total);
    if ($sell->cash >= $sell->total) {
    $pdf->setX(5);
    $pdf->Cell(5, $off + 73, "Cambio : ");
   
    $pdf->setX(65);
    $pdf->Cell(5, $off + 73, "$symbol " . number_format($cambio, 2, '.', ','), 0, 0, "R");
    }

 */

    $pdf->SetFont('courier', 'B', 13);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->setX(5);
 
    $pdf->Cell(5, $off + 70, "Por Pagar : ");
    $pdf->setX(65);
   
    $pdf->Cell(5, $off + 70, "$symbol " . number_format($sell->total_por_pagar, 2, ".", ","), 0, 0, "R");  
  
    $pdf->setX(1);
    $pdf->SetFont('courier', 'B', 11);    //Letra Arial, negrita (Bold), tam. 20
   
   

    $pdf->Cell(1, $off + 80, "=================================");
}


$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(20);
$pdf->Cell(5, $off + 86, 'Articulos :  ' . strtoupper($acumulador));


$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(5);
$pdf->Cell(5, $off + 96, 'FUE ATENDIDO POR :  ' . strtoupper($user->name . " " . $user->lastname));
   
$pdf->ln(2);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(1);
$pdf->Cell(5, $off + 100, 'ESTE TICKET NO ES COMPROBANTE FISCAL');

/*
$pdf->ln(50);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(1);
$pdf->Cell(5, $off + 9, ' == ACEPTAMOS TARJETAS DE CREDITO ==');
*/ 

$pdf->ln(50);
$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(20);
$pdf->Cell(5, $off + 11, '= MALLA PARAISO =');
$pdf->ln(4);   
$pdf->setX(15);
$pdf->Cell(5, $off + 12, '= AGRADECE SU COMPRA =');


$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 6);    //Letra Arial, negrita (Bold), tam. 20
//$pdf->AddFont('DejaVu','','DejaVuSansCondensed.ttf',true);
//$pdf->SetFont('DejaVu','',8);
//$pdf->setXY(5,0);
$plusforimage = 0;
if ($ticket_image != "") {
    $src = "storage/configuration/" . $ticket_image;
    if (file_exists($src)) {
        $pdf->Image($src, 20, 2, 40);
        $plusforimage = 48;
    }
}


$textypos = 8 + $plusforimage;
//$pdf->ln(2);
//$pdf->setY(3);
//$pdf->setX(11);
//$pdf->Cell(3, $textypos, strtoupper($company_name));
$pdf->setY(10);
$pdf->SetFont('courier', 'B', 12);
$pdf->setY(17);
$pdf->setX(17);
$pdf->SetFont('courier', 'B', 11);
$pdf->Cell(5, $textypos, strtoupper($stock->name));
$pdf->setY(21);
$pdf->setX(14);
$pdf->SetFont('courier', '', 10);
$pdf->Cell(5, $textypos, strtoupper($stock->colonia));
$pdf->setY(25);
$pdf->setX(20);
$pdf->SetFont('courier', '', 11);
$pdf->Cell(5, $textypos, strtoupper($calle));
$pdf->setY(29);
$pdf->setX(15);
$pdf->Cell(5, $textypos, strtoupper($stock->ciudad));
$pdf->setY(33);
$pdf->setX(9);
$pdf->Cell(5, $textypos, "Telefono:  " . strtoupper($stock->field1));
$pdf->setY(37);
$pdf->setX(9);
$pdf->Cell(5, $textypos, "WhatsApp:  " . strtoupper($stock->field2));
$pdf->setY(24);
$pdf->setX(2);

$pdf->SetFont('courier', 'B', 11);
$pdf->setY(42);
$pdf->setX(2);
$pdf->Cell(5, $textypos, "================================");

$pagado = 0;
// se saca el estado del pago // pagado pendiente.
if($sell->p_id == 1 ){
    $pagado = "Pagada";
}else if ($sell->p_id ==2 ){
    $pagado = "Pendiente";
}else if ($sell->p_id ==4 ){
    $pagado = "Credito";
}

$entregado = 0;
// se saca el estado de entrega // entregado - pendiente.
if($sell->d_id == 1 ){
    $entregado = "Entregada";
}else if ($sell->d_id ==2 ){
    $entregado = "Pendiente";
}

$f_pago = 0;
// se saca el estado de entrega // entregado - pendiente.
if($sell->f_id == 1 ){
    $f_pago = "Efectivo";
}else if ($sell->f_id ==2 ){
    $f_pago = "Transferencia";
}else if ($sell->f_id ==3 ){
    $f_pago = "Tarjeta De Credito";
}else if ($sell->f_id ==4 ){
    $f_pago = "Tarjeta De Debito";
}else if ($sell->f_id ==5 ){
    $f_pago = "Cobro Con Anticipo";
}else if ($sell->f_id ==6 ){
    $f_pago = "Deposito Bancario";
}else if ($sell->f_id ==7 ){
    $f_pago = "Pago Con Cheque";
}else if ($sell->f_id ==8 ){
    $f_pago = "Por Definir";
}


//$pdf->SetFont('DejaVu','',5);    //Letra Arial, negrita (Bold), tam. 20
$pdf->SetFont('courier', 'B', 5);    //Letra Arial, negrita (Bold), tam. 20
$textypos += 9;
$pdf->setX(2);

$textypos += 1;
$pdf->setX(16);
$pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, " # Remision - " . $sell->id);
$pdf->ln(4);
$pdf->setX(8);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(20, $textypos, "Fecha : " . $sell->fecha_remision);
$pdf->ln(4);

$pdf->setX(21);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, "Pago  : " . $pagado);
$pdf->ln(4);

$pdf->setX(17);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, "Entrega : " . $entregado);
$pdf->ln(4);

$pdf->setX(6);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, "Forma Pago : " . $f_pago);


if($sell->remision_recuperada == 1 ){

    $pdf->ln(4);
$pdf->setX(6);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(20, $textypos, "Fecha Pago : " . $sell->fecha_pago);

}

if ($sell->person_id != null) {
    $textypos += 10;
    $pdf->setX(2);
    $pdf->SetFont('courier', 'B', 11);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, '=== Informacion Del Cliente ===');

    $client = PersonData::getById($sell->person_id);

    $textypos += 8;
    $pdf->setX(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, "RFC : " . strtoupper($client->no));

    $textypos += 8;
    $pdf->setX(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, "Telefono: " . strtoupper($client->phone1));

    $pdf->ln(50);
    $pdf->setX(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,4, "Cliente: " .$client->name . ' ' . $client->lastname);

    $pdf->ln(1);
    $pdf->setx(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,4, "Direccion: " .utf8_decode($client->address1),'C');
   
}

$textypos += -80;
$pdf->setX(2);
$pdf->SetFont('courier', 'b', 12);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(5, $textypos, '===== Listado Productos =====');
$textypos += 10;
$pdf->setX(4);
$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(5, $textypos, 'CANT   DESCRIPCION   PRECIO  TOTAL');

$total = 0;
$acumulador =0;
$off = $textypos + -24;
$pdf->ln(14);
foreach ($operations as $op) {
    $product = $op->getProduct();
 
    $pdf->setX(4);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,3,$op->q);

    $pdf->setX(4);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,4,utf8_encode($op->descripcion));

    $pdf->setX(15);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,6,"$symbol " . number_format($op->price_out, 2, ".", ",")."    $symbol " . number_format($op->q * $op->price_out, 2, ".", ","));
   
    $total += $op->q * $product->price_out;
    $acumulador += $op->q;
   


    /*
    $pdf->setX(5);
    $pdf->ln(5);
    $pdf->setX(30);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(1, $off, "$symbol " . number_format($op->price_out, 2, ".", ","), 0, 0, "R");
    $pdf->setX(60);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(1, $off, "$symbol " . number_format($op->q * $op->price_out, 2, ".", ","), 0, 0, "R");

//    ".."  ".number_format($op->q*$product->price_out,2,".",","));
      $total += $op->q * $product->price_out;
      $acumulador += $op->q;
*/

} 

$textypos += 6;
//////////////////////////////////////////////
 if (Core::$plus_iva == 1) {

    $textypos += -16;
    $pdf->setX(2);
    $pdf->SetFont('courier', 'B', 11);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, '======== Datos De Venta ========');

    $total = $sell->total;
    $iva_calc = ( ($total) / (1 + ($iva_val / 100) )) * ($iva_val / 100);
    $pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
     
    $pdf->setX(5);
    $pdf->Cell(5, $off + 23, "SubTotal :  ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 23, "$symbol " . number_format($sell->sub_total , 2, ".", ","), 0, 0, "R");
    
    $pdf->setX(5);
    $pdf->Cell(5, $off + 34, "Impuesto :  ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 34, "$symbol " . number_format($sell->iva, 2, ".", ","), 0, 0, "R");


    $pdf->setX(5);
    $pdf->Cell(5, $off + 46, "Total :  ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 46, "$symbol " . number_format($total, 2, ".", ","), 0, 0, "R");
    

    $pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->setX(5);
    $pdf->Cell(5, $off + 57, "Anticipo : ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 57, "$symbol " . number_format($sell->reg_anticipo, 2, ".", ","), 0, 0, "R");

    /*
    $pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->setX(5);
    $pdf->Cell(5, $off + 63, "Efectivo : ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 63, "$symbol " . number_format($sell->cash, 2, ".", ","), 0, 0, "R");
*/

/*
    $cambio = $sell->cash - ($total);
    if ($sell->cash >= $sell->total) {
    $pdf->setX(5);
    $pdf->Cell(5, $off + 73, "Cambio : ");
   
    $pdf->setX(65);
    $pdf->Cell(5, $off + 73, "$symbol " . number_format($cambio, 2, '.', ','), 0, 0, "R");
    }

 */

    $pdf->SetFont('courier', 'B', 13);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->setX(5);
 
    $pdf->Cell(5, $off + 70, "Por Pagar : ");
    $pdf->setX(65);
   
    $pdf->Cell(5, $off + 70, "$symbol " . number_format($sell->total_por_pagar, 2, ".", ","), 0, 0, "R");  
  
    $pdf->setX(1);
    $pdf->SetFont('courier', 'B', 11);    //Letra Arial, negrita (Bold), tam. 20
   
   

    $pdf->Cell(1, $off + 80, "=================================");
}


$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(20);
$pdf->Cell(5, $off + 86, 'Articulos :  ' . strtoupper($acumulador));


$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(5);
$pdf->Cell(5, $off + 96, 'FUE ATENDIDO POR :  ' . strtoupper($user->name . " " . $user->lastname));
   
$pdf->ln(2);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(1);
$pdf->Cell(5, $off + 100, 'ESTE TICKET NO ES COMPROBANTE FISCAL');

/*
$pdf->ln(50);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(1);
$pdf->Cell(5, $off + 9, ' == ACEPTAMOS TARJETAS DE CREDITO ==');
*/ 

$pdf->ln(50);
$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(20);
$pdf->Cell(5, $off + 11, '= MALLA PARAISO =');
$pdf->ln(4);   
$pdf->setX(15);
$pdf->Cell(5, $off + 12, '= AGRADECE SU COMPRA =');


$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 6);    //Letra Arial, negrita (Bold), tam. 20
//$pdf->AddFont('DejaVu','','DejaVuSansCondensed.ttf',true);
//$pdf->SetFont('DejaVu','',8);
//$pdf->setXY(5,0);
$plusforimage = 0;
if ($ticket_image != "") {
    $src = "storage/configuration/" . $ticket_image;
    if (file_exists($src)) {
        $pdf->Image($src, 20, 2, 40);
        $plusforimage = 48;
    }
}


$textypos = 8 + $plusforimage;
//$pdf->ln(2);
//$pdf->setY(3);
//$pdf->setX(11);
//$pdf->Cell(3, $textypos, strtoupper($company_name));
$pdf->setY(10);
$pdf->SetFont('courier', 'B', 12);
$pdf->setY(17);
$pdf->setX(17);
$pdf->SetFont('courier', 'B', 11);
$pdf->Cell(5, $textypos, strtoupper($stock->name));
$pdf->setY(21);
$pdf->setX(14);
$pdf->SetFont('courier', '', 10);
$pdf->Cell(5, $textypos, strtoupper($stock->colonia));
$pdf->setY(25);
$pdf->setX(20);
$pdf->SetFont('courier', '', 11);
$pdf->Cell(5, $textypos, strtoupper($calle));
$pdf->setY(29);
$pdf->setX(15);
$pdf->Cell(5, $textypos, strtoupper($stock->ciudad));
$pdf->setY(33);
$pdf->setX(9);
$pdf->Cell(5, $textypos, "Telefono:  " . strtoupper($stock->field1));
$pdf->setY(37);
$pdf->setX(9);
$pdf->Cell(5, $textypos, "WhatsApp:  " . strtoupper($stock->field2));
$pdf->setY(24);
$pdf->setX(2);

$pdf->SetFont('courier', 'B', 11);
$pdf->setY(42);
$pdf->setX(2);
$pdf->Cell(5, $textypos, "================================");

$pagado = 0;
// se saca el estado del pago // pagado pendiente.
if($sell->p_id == 1 ){
    $pagado = "Pagada";
}else if ($sell->p_id ==2 ){
    $pagado = "Pendiente";
}else if ($sell->p_id ==4 ){
    $pagado = "Credito";
}

$entregado = 0;
// se saca el estado de entrega // entregado - pendiente.
if($sell->d_id == 1 ){
    $entregado = "Entregada";
}else if ($sell->d_id ==2 ){
    $entregado = "Pendiente";
}

$f_pago = 0;
// se saca el estado de entrega // entregado - pendiente.
if($sell->f_id == 1 ){
    $f_pago = "Efectivo";
}else if ($sell->f_id ==2 ){
    $f_pago = "Transferencia";
}else if ($sell->f_id ==3 ){
    $f_pago = "Tarjeta De Credito";
}else if ($sell->f_id ==4 ){
    $f_pago = "Tarjeta De Debito";
}else if ($sell->f_id ==5 ){
    $f_pago = "Cobro Con Anticipo";
}else if ($sell->f_id ==6 ){
    $f_pago = "Deposito Bancario";
}else if ($sell->f_id ==7 ){
    $f_pago = "Pago Con Cheque";
}else if ($sell->f_id ==8 ){
    $f_pago = "Por Definir";
}


//$pdf->SetFont('DejaVu','',5);    //Letra Arial, negrita (Bold), tam. 20
$pdf->SetFont('courier', 'B', 5);    //Letra Arial, negrita (Bold), tam. 20
$textypos += 9;
$pdf->setX(2);

$textypos += 1;
$pdf->setX(16);
$pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, " # Remision - " . $sell->id);
$pdf->ln(4);
$pdf->setX(8);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(20, $textypos, "Fecha : " . $sell->fecha_remision);
$pdf->ln(4);

$pdf->setX(21);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, "Pago  : " . $pagado);
$pdf->ln(4);

$pdf->setX(17);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, "Entrega : " . $entregado);
$pdf->ln(4);

$pdf->setX(6);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(3, $textypos, "Forma Pago : " . $f_pago);


if($sell->remision_recuperada == 1 ){

    $pdf->ln(4);
$pdf->setX(6);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(20, $textypos, "Fecha Pago : " . $sell->fecha_pago);

}

if ($sell->person_id != null) {
    $textypos += 10;
    $pdf->setX(2);
    $pdf->SetFont('courier', 'B', 11);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, '=== Informacion Del Cliente ===');

    $client = PersonData::getById($sell->person_id);

    $textypos += 8;
    $pdf->setX(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, "RFC : " . strtoupper($client->no));

    $textypos += 8;
    $pdf->setX(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, "Telefono: " . strtoupper($client->phone1));

    $pdf->ln(50);
    $pdf->setX(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,4, "Cliente: " .$client->name . ' ' . $client->lastname);

    $pdf->ln(1);
    $pdf->setx(3);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,4, "Direccion: " .utf8_decode($client->address1),'C');
   
}

$textypos += -80;
$pdf->setX(2);
$pdf->SetFont('courier', 'b', 12);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(5, $textypos, '===== Listado Productos =====');
$textypos += 10;
$pdf->setX(4);
$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
$pdf->Cell(5, $textypos, 'CANT   DESCRIPCION   PRECIO  TOTAL');

$total = 0;
$acumulador =0;
$off = $textypos + -24;
$pdf->ln(14);
foreach ($operations as $op) {
    $product = $op->getProduct();
 
    $pdf->setX(4);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,3,$op->q);

    $pdf->setX(2);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,4,utf8_encode($op->descripcion));

    $pdf->setX(15);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->MultiCell(70,6,"$symbol " . number_format($op->price_out, 2, ".", ",")."    $symbol " . number_format($op->q * $op->price_out, 2, ".", ","));
   
    $total += $op->q * $product->price_out;
    $acumulador += $op->q;
   


    /*
    $pdf->setX(5);
    $pdf->ln(5);
    $pdf->setX(30);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(1, $off, "$symbol " . number_format($op->price_out, 2, ".", ","), 0, 0, "R");
    $pdf->setX(60);
    $pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(1, $off, "$symbol " . number_format($op->q * $op->price_out, 2, ".", ","), 0, 0, "R");

//    ".."  ".number_format($op->q*$product->price_out,2,".",","));
      $total += $op->q * $product->price_out;
      $acumulador += $op->q;
*/

} 

$textypos += 6;
//////////////////////////////////////////////
 if (Core::$plus_iva == 1) {

    $textypos += -16;
    $pdf->setX(2);
    $pdf->SetFont('courier', 'B', 11);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->Cell(5, $textypos, '======== Datos De Venta ========');

    $total = $sell->total;
    $iva_calc = ( ($total) / (1 + ($iva_val / 100) )) * ($iva_val / 100);
    $pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
     
    $pdf->setX(5);
    $pdf->Cell(5, $off + 23, "SubTotal :  ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 23, "$symbol " . number_format($sell->sub_total , 2, ".", ","), 0, 0, "R");
    
    $pdf->setX(5);
    $pdf->Cell(5, $off + 34, "Impuesto :  ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 34, "$symbol " . number_format($sell->iva, 2, ".", ","), 0, 0, "R");


    $pdf->setX(5);
    $pdf->Cell(5, $off + 46, "Total :  ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 46, "$symbol " . number_format($total, 2, ".", ","), 0, 0, "R");
    

    $pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->setX(5);
    $pdf->Cell(5, $off + 57, "Anticipo : ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 57, "$symbol " . number_format($sell->reg_anticipo, 2, ".", ","), 0, 0, "R");

    /*
    $pdf->SetFont('courier', 'B', 12);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->setX(5);
    $pdf->Cell(5, $off + 63, "Efectivo : ");
    $pdf->setX(65);
    $pdf->Cell(5, $off + 63, "$symbol " . number_format($sell->cash, 2, ".", ","), 0, 0, "R");
*/

/*
    $cambio = $sell->cash - ($total);
    if ($sell->cash >= $sell->total) {
    $pdf->setX(5);
    $pdf->Cell(5, $off + 73, "Cambio : ");
   
    $pdf->setX(65);
    $pdf->Cell(5, $off + 73, "$symbol " . number_format($cambio, 2, '.', ','), 0, 0, "R");
    }

 */

    $pdf->SetFont('courier', 'B', 13);    //Letra Arial, negrita (Bold), tam. 20
    $pdf->setX(5);
 
    $pdf->Cell(5, $off + 70, "Por Pagar : ");
    $pdf->setX(65);
   
    $pdf->Cell(5, $off + 70, "$symbol " . number_format($sell->total_por_pagar, 2, ".", ","), 0, 0, "R");  
  
    $pdf->setX(1);
    $pdf->SetFont('courier', 'B', 11);    //Letra Arial, negrita (Bold), tam. 20
   
   

    $pdf->Cell(1, $off + 80, "=================================");
}


$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(20);
$pdf->Cell(5, $off + 86, 'Articulos :  ' . strtoupper($acumulador));


$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(5);
$pdf->Cell(5, $off + 96, 'FUE ATENDIDO POR :  ' . strtoupper($user->name . " " . $user->lastname));
   
$pdf->ln(2);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(1);
$pdf->Cell(5, $off + 100, 'ESTE TICKET NO ES COMPROBANTE FISCAL');

/*
$pdf->ln(50);
$pdf->SetFont('courier', '', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(1);
$pdf->Cell(5, $off + 9, ' == ACEPTAMOS TARJETAS DE CREDITO ==');
*/ 

$pdf->ln(50);
$pdf->SetFont('courier', 'B', 10);    //Letra Arial, negrita (Bold), tam. 20   
$pdf->setX(20);
$pdf->Cell(5, $off + 11, '= MALLA PARAISO =');
$pdf->ln(4);   
$pdf->setX(15);
$pdf->Cell(5, $off + 12, '= AGRADECE SU COMPRA =');


$pdf->output();


