<?php
setlocale(LC_CTYPE, 'es_MX');
include "core/controller/Core.php";
include "core/controller/Database.php";
include "core/controller/Executor.php";
include "core/controller/Model.php";
include "core/app/model/UserData.php";
include "core/app/model/SellData.php";
include "core/app/model/OperationData.php";
include "core/app/model/ProductData.php";
include "core/app/model/StockData.php";
include "core/app/model/ConfigurationData.php";
include "core/app/model/PersonData.php";
include 'connection/conexion.php';
include "fpdf/fpdf.php";
session_start();
if (isset($_SESSION["user_id"])) {
    Core::$user = UserData::getById($_SESSION["user_id"]);
}


$symbol = ConfigurationData::getByPreffix("currency")->val;
if ($symbol == "€") {
    $symbol = chr(128);
} else if ($symbol == "₡") {
//echo intval("€");
    $symbol = '₡';
}

$name = ConfigurationData::getByPreffix("company_name")->val;
$title = ConfigurationData::getByPreffix("ticket_title")->val;
$direction = ConfigurationData::getByPreffix("direction")->val;
$calle = ConfigurationData::getByPreffix("calle")->val;
$rfc = ConfigurationData::getByPreffix("rfc")->val;
$telefono = ConfigurationData::getByPreffix("telefono")->val;
$iva_val = ConfigurationData::getByPreffix("imp-val")->val;
$ticket_image = ConfigurationData::getByPreffix("ticket_image")->val;

$cliente = $_GET['cliente'];
$idabono = $_GET['id'];
$fecha = $_GET['fecha'];
$stock_id = $_GET['stock_id'];



$suc_name = "SELECT * from stock where id = $stock_id";
$resultado = $mysqli->query($suc_name);
$row = mysqli_fetch_assoc($resultado);
$nombre_sucursal = $row['name']; 



$sql_cliente = "SELECT * from person where id = $cliente";
$res_cliente = $mysqli->query($sql_cliente);
$row = mysqli_fetch_assoc($res_cliente);
$nombre_cliente = $row['name']."".$row['lastname']; 
$direccion_cliente = $row['address1']; 
$telefono_cliente = $row['phone1'];
$rfc_cliente =  $row['no'];


$sql_anticipo = "SELECT SUM(cantidad) AS total from bitacora_abonos where idcliente = $cliente";
$res_anticipo = $mysqli->query($sql_anticipo);
$row2 = mysqli_fetch_assoc($res_anticipo);

$monto_total = $row2['total']; 

$pdf = new FPDF($orientation = 'P', $unit = 'mm');

$pdf->AddPage();
$pdf->SetFont('Arial', '', 6);    //Letra Arial, negrita (Bold), tam. 20
//$pdf->AddFont('DejaVu','','DejaVuSansCondensed.ttf',true);
//$pdf->SetFont('DejaVu','',8);
//$pdf->setXY(5,0);
$plusforimage = 0;
if ($ticket_image != "") {
    $src = "storage/configuration/" . $ticket_image;
    if (file_exists($src)) {
      $pdf->Image($src, 15, 4, 45);
        $plusforimage = 25;
    }
}

date_default_timezone_set('America/Monterrey');
$pdf->SetFont('Arial', 'B', 9);

$ancho = 190;
$pdf->SetY(12); //Mencionamos que el curso en la posición Y empezará a los 12 puntos para escribir el Usuario:

$pdf->SetY(15);
$pdf->Cell($ancho, 13,'Fecha Impresion : '.date('d/m/Y'), 0, 0, 'R');
$pdf->SetY(18);
$pdf->Cell($ancho, 16,'Hora Impresion : '.date('H:i:s'), 0, 0, 'R');     



$yy = 15; //Variable auxiliar para desplazarse 40 puntos del borde superior hacia abajo en la coordenada de las Y para evitar que el título este al nivel de la cabecera.
$y = $pdf->GetY(); 
$x = 12;
$pdf->SetFont('helvetica', 'B', 20); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(0, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(220, 20, "Historial De Anticipos", 0, 4, 'C');
$pdf->SetFont('helvetica', 'B', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(95, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página

$pdf->SetFont('helvetica', 'B', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,50,"Informacion General Del Cliente  _____________________________________________________________________");

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,65, "Nombre Cliente : ". $nombre_cliente);

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,75, "RFC : ". $rfc_cliente);

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(140, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,70, "Telefono : ". $telefono_cliente);

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,85, "ID Cliente : ". $cliente);

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,95, "Ciudad / Estado : ". $direccion_cliente);

$pdf->SetFont('helvetica', '', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(140, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,110, "Total Anticipos Disponible : ". $monto_total);



$pdf->SetFont('helvetica', 'B', 10); //Asignar la fuente, el estilo de la fuente (negrita) y el tamaño de la fuente
$pdf->SetXY(10, $y + $yy); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
$pdf->Cell(260,120,"Registro General de Movimientos  ____________________________________________________________________");


$sql = "SELECT * FROM bitacora_abonos WHERE idcliente = $cliente and operacion = 1 ";
 $resultado = $mysqli->query($sql);


 $pdf->ln(70);
 $pdf->SetFont('courier', 'U', 15); //Asignar la fuente, el estilo de la fuente (subrayado) y el tamaño de la fuente
 $y = $pdf->GetY(); 
 $pdf->SetXY(40, $y); //Ubicación según coordenadas X, Y. X=0 porque empezará desde el borde izquierdo de la página
 $pdf->SetFont('arial', '', 8); //Asignar la fuente, el estilo de la fuente (subrayado) y el tamaño de la fuente
 $y = $pdf->GetY() + 1;
 $pdf->SetXY(10, $y);
 $pdf->MultiCell(15, 4, utf8_decode("ID "), 1, 'C'); //Utilizamos el utf8_decode para evitar código basura o ilegible
 $pdf->SetXY(25, $y);
 $pdf->MultiCell(20, 4, utf8_decode("Disponible"), 1, 'C');
 $pdf->SetXY(45, $y);
 $pdf->MultiCell(25, 4, utf8_decode("Cantidad"), 1, 'C');
 $pdf->SetXY(70, $y);
 $pdf->MultiCell(30, 4, utf8_decode("F. Pago"), 1, 'C');  
 $pdf->SetXY(100, $y);
 $pdf->MultiCell(30, 4, utf8_decode("Operacion"), 1, 'C');
 $pdf->SetXY(130, $y);
 $pdf->MultiCell(40, 4, utf8_decode("Fecha Ingreso"), 1, 'C');  
 $pdf->SetXY(170, $y);
 $pdf->MultiCell(32, 4, utf8_decode("ID operación"), 1, 'C');  
 $pdf->SetFont('arial', '', 8); //Asignar la fuente, el estilo de la fuente (subrayado) y el tamaño de la fuente
 $total_entregado=0; 


 while($row = $resultado->fetch_assoc()){
  
  if($row['forma_pago'] == '0'){
    $pago = "No Definido";
  }elseif($row['forma_pago'] == '1'){
    $pago = "Pago En Efectivo";
    }elseif($row['forma_pago'] == '2'){
    $pago = "Transf. Electronica";
    }elseif($row['forma_pago'] == '3'){
    $pago = "Tarjeta De Credito";
    }elseif($row['forma_pago'] == '4'){
    $pago = "Tarjeta De Debito";
    }elseif($row['forma_pago'] == '5'){
    $pago = "Deposito Bancario";
    }elseif($row['forma_pago'] == '6'){
    $pago = "Pago Con Cheque";
    }

      if($row['operacion'] == '1'){
      $operacion = "Ingreso";
      }elseif($row['operacion'] == '2'){
      $operacion = "Ingreso";
      }elseif($row['operacion'] == '3'){
      $operacion = "Compra Con Anticipo";
      }elseif($row['operacion'] == '4'){
      $operacion = "Abono A Credito";
      }elseif($row['operacion'] == '5'){
      $operacion = "Devolucion De Credito";
      }elseif($row['operacion'] == '6'){
      $operacion = "Cancelacion Venta";
      }elseif($row['operacion'] == '7'){
      $operacion = "Credito Liquidado";
      }



$pdf->cell(15, 7,$row['idabonos'],1,0,'C');
$pdf->cell(20, 7,"$ ".$row['cantidad'],1,0,'C');
$pdf->cell(25, 7,"$ ".$row['cant_ingresada'],1,0,'C');
$pdf->cell(30, 7,$pago,1,0,'C');
$pdf->cell(30, 7,$operacion,1,0,'C');
$pdf->cell(40, 7,$row['fecha'],1,0,'C');
$pdf->Multicell(32, 7,$row['factura_electronica'],1,'C');


}









  $pdf->output();


        
 
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    



 








































