<section class="content"> 
    <div class="row">
        <div class="col-md-12">

            <?php if (isset($_SESSION["client_id"])): ?>
                <h1><i class='glyphicon glyphicon-shopping-cart'></i> Mis Compras</h1>
            <?php else: ?>
              
              <!--  <div class="btn-group pull-right">
                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                        <i class="fa fa-download"></i> Descargar <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" role="menu">
                        <?php if (Core::$user->kind == 1): ?>
                            <li><a href="report/sells-word.php">Word 2007 (.docx)</a></li>
                            <li><a href="report/sells-xlsx.php">Excel 2007 (.xlsx)</a></li>
                        <?php endif; ?>
                        <li><a onclick="thePDF()" id="makepdf" class="">PDF (.pdf)</a></li>
                    </ul>
                </div> -->
                
                <div class="panel panel-default">
                        <div class="panel-heading">
						<h1><i class='glyphicon glyphicon glyphicon-shopping-cart'></i> Listado General Cotizaciones Canceladas</h1>
						</div>
						 
                        </div>
<?php endif;?>
		<div class="clearfix"></div>


            <?php
            $products = null;
            if (isset($_SESSION["user_id"])) {
                if (Core::$user->kind == 3) {
                    $products = SellData::getAllBySQL(" where operation_type_id=2 and p_id=3 and d_id=3 and is_draft=1 order by created_at desc");
                } else if (Core::$user->kind == 2 || Core::$user->kind == 4) {
                    $products = SellData::getAllBySQL(" where operation_type_id=2 and p_id=3 and d_id=3 and is_draft=1 and stock_to_id=" . Core::$user->stock_id . " order by created_at desc");
                } else {
                    $products = SellData::getAllBySQL(" where operation_type_id=2 and p_id=3 and d_id=3 and is_draft = 1 ");
                }
            } else if (isset($_SESSION["client_id"])) {
                $products = SellData::getAllBySQL(" where person_id=$_SESSION[client_id] and operation_type_id=2 and p_id=3 and d_id=3 and is_draft=1 order by created_at desc");
            }

            if (count($products) > 0) {
                ?>
                <br>
                <div class="box box-primary">
                    <div class="box-header">
                        <h3 class="box-title">Listado General de Cotizaciones Canceladas</h3></div>
                    <div class="box-body">
                        <table class="table table-bordered table-hover table-responsive datatable	">
                            <thead>
                            <th></th>
                            <th>Folio</th>	
                            <th>Pago</th>
                            <th>Entrega</th>
                            <th>Total</th>
                            <th>Nombre Cliente</th>
                            <th>Vendedor</th>
                            <th>Almacen</th>
                            <th>Fecha Cotización</th>
                            <th>Fecha Cancelacion</th>
                            <th>Motivo</th>
                            </thead>
                            <?php
                            foreach ($products as $sell):
                                $operations = OperationData::getAllProductsBySellId($sell->id);
                                ?>

                                <tr>
                                    <td style="width:30px;">
                                        <a href="index.php?view=onesell&id=<?php echo $sell->id; ?>" class="btn btn-xs btn-default"><i class="glyphicon glyphicon-eye-open"></i></a></td>
                                    <td>#<?php echo $sell->id; ?></td>

                                    <td><?php echo $sell->getP()->name; ?></td>
                                    <td><?php echo $sell->getD()->name; ?></td>
                                    <td>

                                        <?php
                                        $total = $sell->total - $sell->discount;
                                        echo "<b>" . Core::$symbol . " " . number_format($total, 2, ".", ",") . "</b>";
                                        ?>			
                                    </td>
                                    <td> <?php
                                        if ($sell->person_id != null) {
                                            $c = $sell->getPerson();
                                            echo $c->name . " " . $c->lastname;
                                        }
                                        ?> </td>
                                    <td> <?php
                                        if ($sell->user_id != null) {
                                            $c = $sell->getUser();
                                            echo $c->name . " " . $c->lastname;
                                        }
                                        ?> </td>
                                    <td><?php echo $sell->getStockTo()->name; ?></td>
                                    <td><?php echo $sell->created_at; ?></td>
                                    
                                    <td style="width:65px;text-align: center;">
                                      <?php echo $sell->cancelacion; ?>  

                                    </td>
                                    
                                    <td style="width:65px;text-align: center;">
                                        <a id="<?php echo $sell->id; ?>" class="btn btn-xs btn-primary" onclick="detalle(this.id)"><i class="fa fa-search-plus">&nbsp;Motivo</i></a>

                                    </td>
                                </tr>

                            <?php endforeach; ?>

                        </table>
                    </div>
                </div>

                <div class="clearfix"></div>

                <?php
            } else {
                ?>
                <div class="jumbotron">
                    <h2>No hay ventas</h2>
                    <p>No se ha realizado ninguna venta.</p>
                </div>
                <?php
            }
            ?>
        </div>
    </div>
</section>


<script type="text/javascript">
    function detalle(id) {
        $.ajax({
            type: "POST",
            url: "./core/app/action/traer_mot.php",
            data: "id=" + id,
            success: function (data) {
                $("#detalle_can").modal('show');
                $("#motivo_c").html(data);
            }
        });
    }

    function thePDF() {
        var doc = new jsPDF('p', 'pt');
        doc.setFontSize(26);
        doc.text("<?php echo ConfigurationData::getByPreffix("company_name")->val; ?>", 40, 65);
        doc.setFontSize(18);
        doc.text("VENTAS", 40, 80);
        doc.setFontSize(12);
        doc.text("Usuario: <?php echo Core::$user->name . " " . Core::$user->lastname; ?>  -  Fecha: <?php echo date("d-m-Y h:i:s"); ?> ", 40, 90);
        var columns = [
            {title: "Id", dataKey: "id"},
            {title: "Cliente", dataKey: "client"},
            {title: "Total", dataKey: "total"},
            {title: "Estado de pago", dataKey: "p"},
            {title: "Estado de entrega", dataKey: "d"},
            {title: "Almacen", dataKey: "stock"},
            {title: "Fecha", dataKey: "created_at"},
        ];
        var rows = [
<?php foreach ($products as $sell):
    ?>
                {
                    "id": "<?php echo $sell->id; ?>",
                    "client": "<?php
    if ($sell->person_id != null) {
        $c = $sell->getPerson();
        echo $c->name . " " . $c->lastname;
    }
    ?>",
                    "total": "<?php
    $total = $sell->total - $sell->discount;
    echo "$ " . number_format($total, 2, ".", ",");
    ?>	",
                    "p": "<?php echo $sell->getP()->name; ?>",
                    "d": "<?php echo $sell->getD()->name; ?>",
                    "stock": "<?php echo $sell->getStockTo()->name; ?>",
                    "created_at": "<?php echo $sell->created_at; ?>",
                },
<?php endforeach; ?>
        ];
        doc.autoTable(columns, rows, {
            theme: 'grid',
            overflow: 'linebreak',
            styles: {
                fillColor: <?php echo Core::$pdf_table_fillcolor; ?>
            },
            columnStyles: {
                id: {fillColor: <?php echo Core::$pdf_table_column_fillcolor; ?>}
            },
            margin: {top: 100},
            afterPageContent: function (data) {
            }
        });
        doc.setFontSize(12);
        doc.text("<?php echo Core::$pdf_footer; ?>", 40, doc.autoTableEndPosY() + 25);
<?php
$con = ConfigurationData::getByPreffix("report_image");
if ($con != null && $con->val != ""):
    ?>
            var img = new Image();
            img.src = "storage/configuration/<?php echo $con->val; ?>";
            img.onload = function () {
                doc.addImage(img, 'PNG', 495, 20, 60, 60, 'mon');
                doc.save('sells-<?php echo date("d-m-Y h:i:s", time()); ?>.pdf');
            }
<?php else: ?>
            doc.save('sells-<?php echo date("d-m-Y h:i:s", time()); ?>.pdf');
<?php endif; ?>
    }
</script>




<div class="modal fade" id="detalle_can" tabindex="-1"  aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Motivo Cancelacion</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <textarea id="motivo_c" readonly="true" rows="6" cols="80"></textarea>

            </div>
            <div> <label class="error"></label></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            </div>
        </div>
    </div>
</div>


